package o1.robots.tribal

/** This exception type represents situations where a robot tribe file is either
  * unreadable or does not contain a valid RoboSpeak program. */
class TribeFileException(val tribe: Tribe, line: String | Int, details: String = "") extends RuntimeException:

  val message =
    val lineDescription = line match
      case textOnLine: String => s"this line:\n$textOnLine\n"
      case lineNumber: Int    => s"line #$lineNumber:"
    s"Invalid RoboSpeak on $lineDescription\n$details".trim

  override def getMessage = this.message

end TribeFileException









